﻿using System;
using System.ComponentModel;
using System.ComponentModel.Design;
using System.Collections;
using System.Drawing;
using System.Linq;
using System.Workflow.ComponentModel.Compiler;
using System.Workflow.ComponentModel.Serialization;
using System.Workflow.ComponentModel;
using System.Workflow.ComponentModel.Design;
using System.Workflow.Runtime;
using System.Workflow.Activities;
using System.Workflow.Activities.Rules;
using System.Threading;
using System.Collections.Generic;



/*  
    ConditionedActivityGroup conditional activity class      
 
    The execution of a ConditionedActivityGroup is controlled by its UntilCondition
    property and the WhenCondition attatched property of its child activities.
 
    This example uses a ConditionedActivityGroup with 3 CodeActivity objects. 
    The UntilCondition is based on a counter which is decreased when a child
    executes. The same counter field is used to evaluate the WhenCondition too.
 
 
 
 */
namespace Lessons.Workflows
{
	public sealed partial class Workflow1: SequentialWorkflowActivity
	{
		public Workflow1()
		{
			InitializeComponent();
		}

        int counter = 5;  

        void actConditionGroup_UntilCondition(object sender, ConditionalEventArgs e)
        {
            e.Result = counter <= 0;

            if (e.Result)
            {
                Console.WriteLine("finishing....");                
            }
        }


        void anyActivity_WhenCondition(object sender, ConditionalEventArgs e)
        {
            Activity a = sender as Activity;

            if (a.Name == "actCode1")
                e.Result = true;
            else if (a.Name == "actCode2")
                e.Result = counter % 2 == 0;
            else if (a.Name == "actCode3")
                e.Result = counter % 3 == 0;

        }


        private void anyCodeActivity_ExecuteCode(object sender, EventArgs e)
        {
            Activity a = sender as Activity;
            Console.WriteLine(a.Name + ": executing code...  Counter = " + counter.ToString());
            Thread.Sleep(100);
            if (a.Name == "actCode1")
                counter--;
        }
 


        





	}








}







 







 